### 概述

ZKSDTempControl是用于温度控制的算法库或称做温度控制器。控制器可以运行在自动模式（闭环）和手动模式（开环）。

控制器的输出可以是数字量或模拟量，数字控制值是脉宽调制（PWM）的。且支持两点或三点式输出。控制值被限制在允许的最小值和最大值之间。

设定值被限制在允许的最小值和最大值之间，也可以是斜坡输入。通过功能块的接口，可以从设定值切换到备用设定值。软启动功能可以进行参数化设置，以支持“加热器烘烤”操作。此过程包括：设定值（可选斜坡调整）初始设置为较低的值，在该值上保持一定时间，然后将设定值更改为目标设定值（可选斜坡调整）。

实际值可以进行数字滤波。

控制算法基于PID（比例-积分-微分）原理，并可添加一个前馈控制器，以最小化超调现象。

下表概述了各个产品组件

| **产品组件**                          | **描述说明** |
| --------------------------------- | -------- |
| FB\_CTRL\_Selftunner              | 自整定算法    |
| FB\_CTRL\_ControlAlgorithm        | 控制算法     |
| FB\_CTRL\_SetPointConditioner     | 设定值发生器   |
| FB\_CTRL\_ControlValueConditioner | 控制值发生器   |
| FB\_Alarming                      | 报警       |

---
### 安装卸载

**安装要求**

本节描述工程和/或运行时系统所需的最低要求。

**1、硬件要求**

支持 MetaFacture 平台的设备（ PLC 或嵌入式系统）。

**2、软件要求**

已安装 MetaFacture 的开发环境。

操作系统支持：MetaOS或其他兼容平台。

必须具备相关的库或模块依赖（如基础 I/O 库）

**安装过程**

在 MetaFacture 中打开工程项目。

通过菜单选择“工具”->“库存储”。
![](https://resource.helplook.net/docker_production/3648ne/article/1iCNeRbk/680ef9a8a46d3.png)


点击安装，打&#x5F00;**&#x20;ZKSDTempControl.compiled-library** 库文件。
![](https://resource.helplook.net/docker_production/3648ne/article/1iCNeRbk/680ef9bfcbc17.jpg)


打开成功，关闭窗口。

点击”添加库“
![](https://resource.helplook.net/docker_production/3648ne/article/1iCNeRbk/680ef9b747f7e.png)


选&#x4E2D;**&#x20; ZKSDTempControl&#x20;**，点击确&#x5B9A;**。**
![](https://resource.helplook.net/docker_production/3648ne/article/1iCNeRbk/680ef9cbba3d0.png)


**更新安装**

**1、覆盖安装**

下载最新版本的 ZKSDTempControl 库文件。

打开 MetaFacture 工程，在“库管理器”中删除旧版本的库，导入新版本库文件。

保存工程并重新编译。

**2、版本兼容性验证**

检查新版本是否与现有工程兼容。

根据文档调整旧版本与新版本可能的差异。

**卸载过程**

**1、通过库管理器卸载**

打开 MetaFacture 项目，进入“库管理器”。

选择 ZKSDTempControl 库，点击“删除库”卸载库文件。
![](https://resource.helplook.net/docker_production/3648ne/article/1iCNeRbk/680ef9e2ab147.png)


2、**清理项目依赖**

打开工程项目，检查并移除所有使用 ZKSDTempControl 库的功能块或接口。

确保工程重新编译时无报错。

---
### 功能介绍

#### 结构框图

温度控制器由以下功能块组成：

* 自整定算法（ FB\_CTRL\_Selftunner ）

* 控制算法（FB\_CTRL\_ControlAlgorithm）

* 设定值发生器（FB\_CTRL\_SetPointConditioner）

* 控制值发生器（FB\_CTRL\_ControlValueConditioner）

* 报警（FB\_Alarming）

这些功能块依次调用其他附属功能块。
![](https://resource.helplook.net/docker_production/3648ne/article/1iCNeRbk/680ef9f2d31f3.png)


#### 设定值发生器

设定值发生器示意图如下图所示。

设定温度有两个值，实际设定温度和备用设定温度。备用设定温度可用于加热暂停期间将温度降低到较低的值以节省电力，也可称作保温功能。如有必要，可以按照设定斜坡逐步调整设定点。

设定值受到其限制范围的约束。
![](https://resource.helplook.net/docker_production/3648ne/article/1iCNeRbk/680efa0d52c57.png)


使用“软启动”功能时可以进行参数化设置。启用“软启动”时，温度首先从环境温度上升到低设定值 (fWStartUp)，然后将该温度保持一段时间 (tStartUp)，此后开始向实际设定值上升。
![](https://resource.helplook.net/docker_production/3648ne/article/1iCNeRbk/680efa13e4c67.png)


#### 控制值调节器

控制器计算的控制值首先经过限制，限值通过控制值结构传递给控制器功能块。控制值以三种不同的方式提供。控制值可以以模拟形式输出。也可以以数字输出采用脉宽调制信号的形式。脉宽调制所需的循环时间以控制值结构提供给控制器。此外，可以连接两点输出（用于加热或冷却）和三点输出（用于加热或冷却）。
![](https://resource.helplook.net/docker_production/3648ne/article/1iCNeRbk/680efa1a3cc46.png)

---
### 控制算法
![](https://resource.helplook.net/docker_production/3648ne/article/1iCNeRbk/680efa33c5266.png)


温度控制器的核心是一个标准的 PID 控制器。该控制器内核还支持防止积分饱和（Anti-Reset Windup）措施，以在控制值受到限制时约束积分（I）分量的作用。由于控制器采用了 Chien、Hrones 和 Reswick 的整定方法，旨在最小化扰动，因此在设定值变化时可能会出现超调现象。

为了减少这种超调，可以插入一个前馈控制器（Pre-Controller）来处理设定值的变化。前馈控制器具有 D-T1 特性，可整体上减小控制器的振荡。然而，由于前馈控制器的 D 分量会使控制值出现“粗化”效应，因此在使用前馈控制器时必须非常谨慎。

当实际值进入设定值的某个范围内并保持一段时间后，前馈控制器会被关闭。前馈控制器的关闭是通过一个较长时间的斜坡下降过程来完成的。为了最小化控制值的振荡，还可以选择在主控制器后添加一个滤波器。为此提供了 P-T1 滤波器和移动平均滤波器两种选项。

**使用要求**

| 开发环境        | 目标平台 | 需要包含的**PLC 库**  |
| ----------- | ---- | --------------- |
| MetaFacture | PC   | ZKSDTempControl |


---
### 报警
![](https://resource.helplook.net/docker_production/3648ne/article/1iCNeRbk/680efa41c9da5.png)


控制器持续监控以下报警条件：

* 绝对温度值（高值和低值）

* 相对温度值（设定值附近的高值和低值带）

以下与传感器相关的硬件条件也可以链接到温度控制器：

* 热电偶断线：传感器断线

* 反向电压：传感器上存在超出允许范围的电压

* 热电偶接线反向

如果是电流型传感器，则以下信号可以连接到控制器：

* 短路

* 断路

* 漏电流



**使用要求**

| 开发环境        | 目标平台 | 需要包含的**PLC 库**  |
| ----------- | ---- | --------------- |
| MetaFacture | PC   | ZKSDTempControl |

---
### 参数自整定

自整定算法基于经典的拐点切线法（Inflectional Tangents Method）。该方法最早由 Ziegler 和 Nichols 提出，假设被分析的系统为具有延迟时间的线性 P-T1 回路。

在实验步骤中，首先通过观察若干采样点之间的差值，确定最大变化速率（Vmax）。然后，在变化速率达到最大值的点上构建切线，并找到该切线与时间轴的交点。延迟时间（Tu）是从测量开始到拐点切线与时间轴交点之间的时间。

通过已知的 Tu 和 Vmax，可以使用 Chien、Hrones 和 Reswick 提出的公式计算出控制器参数，从而实现具有 20% 超调的扰动抑制。这些参数通过启发式公式，也可以轻松推导出前馈控制器的参数。

完成自整定后，控制器会自动切换到闭环运行，并使用计算出的参数进行控制。


**使用要求**

| 开发环境        | 目标平台 | 需要包含的**PLC 库**  |
| ----------- | ---- | --------------- |
| MetaFacture | PC   | ZKSDTempControl |

## 使用与调试

需要执行的步骤如下：

（一）通过库管理器将温度控制器库添加到项目中

（二）至少实例化一个温度控制器

* 创建一个控制器功能块FB\_TempController的实例

* 创建一个ST\_ControllerParameter结构的实例。

（三）管脚连接

| 名称                      | 是否可选 | 描述                          |
| ----------------------- | ---- | --------------------------- |
| eCtrlMode               | 必须   | 操作模式: passive, activ, check |
| bSelSetpoint            | 可选   | FALSE = fW1, TRUE = fW2     |
| fW1                     | 必须   | 设定点                         |
| fW2                     | 可选   | 备选设定点，一般低于fW1               |
| fX                      | 必须   | 实际值                         |
| fYManual                | 可选   | 手动模式下的控制值                   |
| bOpenThermocouple       | 可选   | TRUE: 热电偶断线，硬件反馈信号          |
| bReverseThermocouple    | 可选   | TRUE: 热电偶接线错误               |
| bBackVoltage            | 可选   | TRUE: 热电偶接线错误               |
| bLeakage                | 可选   | TRUE: 加热单元检测到漏电流，硬件反馈信号     |
| bShortCircuit           | 可选   | TRUE: 加热单元检测到短路，硬件反馈信号      |
| bOpenCircuit            | 可选   | TRUE: 加热单元检测到断路，硬件反馈信号      |
| sParaControllerExternal | 可选   | 外部控制器参数                     |
| sControllerParameter    | 必须   | 一般参数（采样时间等）                 |

（四）参数初始化，示例如下：

（五）设置控制器采样时间，任务周期，和PWM周期。

* 控制器的采样时间等于或者小于控制周期的十分之一。

* 任务周期取决于PLC的设置。PWM周期通常等于控制器的循环时间。如果任务周期为10ms，且PWM周期为100ms，则总共有10个等级可用。

（六）示波器参数化

* 启用数据录播功能，对调谐过程和闭环控制行为进行记录。

* 监控以下通道：设定值 (fW1/fW2)，实际值 (fX) 和模拟控制值 (fYAnalog)。

（七）调试阶段关闭报警

* 在调试阶段可以暂时关闭报警，在dwAlarmSupp Dword中设置相应的位掩码。

* 如果在 Dword中设置了位掩码，相应的报警会被关闭。各个警报的描述可以在[此处](https://bd3ubzo9h2.feishu.cn/wiki/OtTgwQQzgiMcMIkZjxdcVQEknkh?fromScene=spaceOverview#share-ZpjId5TZioSKOmx4q3WcJvDRnOf)查看。

（八）启动控制器自整定

* 如果要通过自整定来确定控制器参数，则必须将控制模式设置为eCTRL\_mode\_TUNE。

* 在开始阶段，系统会等待固定的20秒。在此等待期间，监测该部分的温度，以确保其保持在±1°C的范围内。如果温度超出此范围，等待时间将重新计时。随后，系统会该部分施加一个控制值为 fYTune 的阶跃激励，该部分将以阶跃响应形式做出反应。在未达到设定值的80%之前，系统使用切线拐点法确定参数。出于安全原因，当温度达到设定值的80%后，系统切换为闭环控制模式。如果温度过快达到 80% 标记（没有清晰的拐点），则需要减小 fYTune 的值。通过上述方法确定的参数将用于PID控制器，并在控制器输出端的结构中提供。

（九）连接内部控制参数与外部连接

* 在整定过程中确定的控制器参数可以作为外部参数再次提供给控制器。这在某些情况下可能是必要的，例如仅在初次调试期间执行一次整定时。

* 为此，将sParaControllerInternal结构反馈到控制器的sParaControllerExternal输入，并将bSelCtrlParameterSet标志设置为TRUE。

（十）手动微调

在整定过程中确定的控制参数旨在实现快速稳定，通常伴随约10%的超调。如果仅允许极少的超调甚至不允许超调，可以使用 ST\_ControllerParameter 结构中的以下参数进行微调。这些值仅作为参考值提供。

| 行为             | fTuneKp | fTuneTn | fTuneTv | fTuneTd |
| -------------- | ------- | ------- | ------- | ------- |
| 快速设定，10%-20%超调 | 1.2     | 2.0     | 0.42    | 0.25    |
| 较慢设定，较少超调      | 1.0     | 2.5     | 0.42    | 0.25    |
| 缓慢调节，几乎无超调     | 0.5     | 3.0     | 1.0     | 0.25    |



**使用要求**

| 开发环境        | 目标平台 | 需要包含的**PLC 库**  |
| ----------- | ---- | --------------- |
| MetaFacture | PC   | ZKSDTempControl |